/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse vec4(0.0,0.0, 0.0,0.0)

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel1;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////
// Lightning (based on a binary tree) written 2015-11-18 by Jakob Thomsen
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

// Lighting based on binary-tree https://www.shadertoy.com/view/lljXW3
/*
vec2 BinaryTreeSubDiv2(vec2 v)
{
    v *= exp2(ceil(-log2(v.y)));
    v.x *= .5;
    return fract(v);
}
*/
vec2 BinaryTreeSubDiv2(vec2 v)
{
    v.x *= .5;
    return fract(v * exp2(ceil(-log2(v.y))));
}

// iq's hash function from https://www.shadertoy.com/view/MslGD8
//vec2 hash( vec2 p ) { p=vec2(dot(p,vec2(127.1,311.7)),dot(p,vec2(269.5,183.3))); return fract(sin(p)*18.5453); }
// adjusted for single input
//vec2 hash(float q) { vec2 p = vec2(q); p=vec2(dot(p,vec2(127.1,311.7)),dot(p,vec2(269.5,183.3))); return fract(sin(p)*18.5453); }
// XXX should be equivalent to original but produces different results XXX
vec2 hash(float p) // simplified for single input
{
    return fract(sin(p * vec2(438.8, 452.8)) * 18.5453);
}

void mainImage( out vec4 o, in vec2 U )
{
    U /= iResolution.xy;
    //U.x *= iResolution.x / iResolution.y;
    vec4 rnd0 = texture2D(iChannel1, U + iGlobalTime * .1);
    vec4 rnd1 = texture2D(iChannel1, .1 * U + iGlobalTime * .1);
    vec2 V = BinaryTreeSubDiv2(U * vec2(1., .75) + .1 * vec2(2. * rnd1.x - 1., 0.));
    //float trigger = clamp(10.*pow(hash(iGlobalTime).x, 5.)-9.,0.,1.);
    float trigger = 10.*pow(hash(iGlobalTime).x, 5.)-9.;
    trigger = max(trigger, 1.0 - smoothstep(0.0, 0.125, abs(iGlobalTime - 10.))); // force lightning for icon at 10s
    //o = vec4(4. * trigger * clamp(rnd1.y*(1. - smoothstep(0., .15 * rnd0.x, abs(4. * abs(V.x -.5) - (1. - V.y)))), 0., 1.));
    o = vec4(4. * trigger * (rnd1.y*(1. - smoothstep(0., .15 * rnd0.x, abs(4. * abs(V.x -.5) - (1. - V.y))))));
}

void main ( void )
{ mainImage ( gl_FragColor, gl_FragCoord.xy );
}
